#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAX_N 200000

typedef struct {
    long long x;
    long long y;
} Point;

Point points[MAX_N];

long long total_greetings = 0;

long long combinations_2(long long k) {
    if (k < 2) return 0;
    return k * (k - 1) / 2;
}

void count_greetings_by_group(int n, int factor, int (*compare_func)(const void*, const void*)) {
    qsort(points, n, sizeof(Point), compare_func);
    
    int i = 0;
    while (i < n) {
        int j = i;
        while (j < n && compare_func(&points[i], &points[j]) == 0) {
            j++;
        }
        
        long long k = j - i;
        
        if (factor == 2) {
             total_greetings += k * (k - 1);
        } else if (factor == 1) {
             total_greetings += combinations_2(k);
        }
        
        i = j;
    }
}

int compare_u(const void* a, const void* b) {
    Point pa = *(const Point*)a;
    Point pb = *(const Point*)b;
    long long u_a = pa.x - pa.y;
    long long u_b = pb.x - pb.y;

    if (u_a < u_b) return -1;
    if (u_a > u_b) return 1;
    
    if (pa.x < pb.x) return -1;
    if (pa.x > pb.x) return 1;
    
    return 0;
}

int compare_v(const void* a, const void* b) {
    Point pa = *(const Point*)a;
    Point pb = *(const Point*)b;
    long long v_a = pa.x + pa.y;
    long long v_b = pb.x + pb.y;

    if (v_a < v_b) return -1;
    if (v_a > v_b) return 1;
    
    if (pa.x < pb.x) return -1;
    if (pa.x > pb.x) return 1;
    
    return 0;
}

int compare_x_yparity(const void* a, const void* b) {
    Point pa = *(const Point*)a;
    Point pb = *(const Point*)b;

    if (pa.x < pb.x) return -1;
    if (pa.x > pb.x) return 1;

    int y_parity_a = (int)(llabs(pa.y) % 2);
    int y_parity_b = (int)(llabs(pb.y) % 2);

    if (y_parity_a < y_parity_b) return -1;
    if (y_parity_a > y_parity_b) return 1;

    return 0;
}

int compare_y_xparity(const void* a, const void* b) {
    Point pa = *(const Point*)a;
    Point pb = *(const Point*)b;

    if (pa.y < pb.y) return -1;
    if (pa.y > pb.y) return 1;

    int x_parity_a = (int)(llabs(pa.x) % 2);
    int x_parity_b = (int)(llabs(pb.x) % 2);

    if (x_parity_a < x_parity_b) return -1;
    if (x_parity_a > x_parity_b) return 1;

    return 0;
}


int main() {
    int N;
    if (scanf("%d", &N) != 1) return 1;

    for (int i = 0; i < N; ++i) {
        if (scanf("%lld %lld", &points[i].x, &points[i].y) != 2) return 1;
    }

    // ?????????? I: u = x-y
    count_greetings_by_group(N, 2, compare_u);

    // ?????????? I: v = x+y
    count_greetings_by_group(N, 2, compare_v);

    // ?????????? II: ???? $x$ + ???? ??????? $y$
    count_greetings_by_group(N, 1, compare_x_yparity);

    // ?????????? II: ???? $y$ + ???? ??????? $x$
    count_greetings_by_group(N, 1, compare_y_xparity);

    printf("%lld\n", total_greetings);

    return 0;
}